---
title: 결제 연동 시작하기
description: 새롭게 출시된 V2 결제 서비스를 소개합니다.
targetVersions:
  - v2
versionVariants:
  v1: /opi/ko/integration/start/v1/readme
---

## 포트원 신모듈 소개 \[V2]

포트원 V2는 10년 간의 포트원 운영 경험을 바탕으로 새롭게 설계되었습니다. 개발자 경험의 혁신적인 개선을 통해 포트원을 연동하는 개발자들은
더욱 쉽게 시스템을 이해하고 빠르게 결제 기능을 연동할 수 있습니다.
또한 포트원 V2는 사용자가 직접 느낄 수 있는 개발자 경험의 개선 이외에도, 눈에 보이지 않는 내부적인 부분 또한 많은 개선을 이루었습니다.

### 혁신적인 개발자 경험: 쉽고 편리한 결제 연동

(이미지 첨부: \<V2 OpenAPI 문서 & 활용 예시>)

포트원 V2는 개발자 경험(Developer Experience)을 혁신적으로 개선하여 쉽고 편리한 결제 연동을 돕습니다.
포트원이 제공하는 차별화된 개발자 경험의 예시는 아래와 같습니다.

- **Open API Spec Download**

  - 연동용 코드 자동 생성, Custom API Document 활용, Postman Import 등에
    사용 가능한 Open API Spec을 다운로드하실 수 있는 기능을 제공합니다.

    (이미지 첨부: \<Postman 에서 Open API Spec 파일 Import 하기>)

    <br />

    (이미지 첨부: \<Postman Import 후 API Structure 예시>)

  - **직관성 있는 스키마 설계**

    - open API spec 파일은 [REST API 문서 페이지](../../../../../../api/rest-v2)에서 **OpenAPI JSON 내려받기** 버튼을 눌러
      다운 받으실 수 있습니다.

    - 타입에 따라 달라지는 스키마 구조를 정확히 표현하여 더욱 예측 가능한 인터페이스로 디자인했습니다.

    - 예를 들어 가상계좌로 결제한 결제 건을 조회한다고 가정했을 때, 해당 결제 건은 계좌번호를 항상 포함하고 있을 것입니다.
      하지만 기존 시스템을 이용하는 경우, 결제수단별로 응답 스키마가 달라지지 않고 모든 필드를 열거하고 있기 때문에
      가상계좌 결제 건임에도 계좌번호는 optional로 제공됩니다.
      반면 포트원 V2는 결제수단별로 달라지는 스키마 구조를 정확히 표현하고 있기 때문에, 가상계좌 결제 건일 때는
      계좌번호가 required로 제공된다는 것이 타입으로 보장됩니다.

    - 이러한 예시를 통해 확인할 수 있듯이, 개발자는 포트원 V2의 직관적인 인터페이스를 통해 결제 시스템을 쉽게 이해하고 불필요한 코드 작성을 최소화할 수 있습니다.

      (이미지 첨부: \<V2 스키마 설계 예시>)

  - **npm, Typescript 지원**

    - V2 SDK는 Typescript로 작성되어 함수의 파라미터 및 응답의 타입을 확인하실 수 있고, npm을 통해 install이 가능합니다.

      (이미지 첨부: \<V2 SDK Typescript 코드 예시>)

## 내부 시스템 개선: 풍부한 데이터와 견고한 서버

포트원 V2는 개발자 경험의 개선을 통해 연동의 편리함을 보장하면서, 장기적으로 고객사의 서비스 운영에 도움이 될 만한 내부 시스템 개선을 진행했습니다.
고객사의 제품 품질 향상과 개선된 비즈니스 의사결정을 도울 수 있는 풍부한 데이터를 제공합니다. 또한 안정적인 운영을 위해 훨씬 더 견고한 시스템을 구축했습니다.

### 확장성: 무한한 가능성을 열어주는 결제 시스템

V2는 '항상 준비된 시스템'입니다. 향상된 [오토스케일링](https://ko.wikipedia.org/wiki/%EC%98%A4%ED%86%A0%EC%8A%A4%EC%BC%80%EC%9D%BC%EB%A7%81)
능력을 제공하는 포트원 V2는 블랙프라이데이부터 크리스마스 선착순 이벤트까지, 아무리 많은 결제 트래픽이 몰려도 문제없이 처리할 수 있습니다.
V1의 오토스케일링도 훌륭하지만, V2는 더 빠른 반응 속도로 더 많은 트래픽을 감당할 수 있는 '진화된 스케일링 능력'을 갖췄습니다.

### 안정성: 신뢰할 수 있는 서버

V2의 서버 시스템은 더욱 강해졌습니다. 휴먼 에러의 위험성을 극단적으로 줄이기 위해 모든 서버 시스템은 자동화된 코드로 관리됩니다.
추가로 [Scala](https://ko.wikipedia.org/wiki/%EC%8A%A4%EC%B9%BC%EB%9D%BC_\(%ED%94%84%EB%A1%9C%EA%B7%B8%EB%9E%98%EB%B0%8D_%EC%96%B8%EC%96%B4\))와
같은 강타입 언어를 사용하여 시스템의 안정성을 더욱 강화했습니다.

### 완벽한 데이터 보존: 우수한 데이터 정합성과 풍부한 정보 제공

V2는 모든 데이터를 수집하고 기록합니다. [Event Sourcing](https://learn.microsoft.com/ko-kr/azure/architecture/patterns/event-sourcing)
기술을 접목하여 서비스의 모든 결제 처리 내역을 빠짐없이 보존합니다. 이를 통해 비즈니스 의사결정에 필요한 주요 정보를 풍부하게 제공합니다.

### 기능 확장: 신속한 업데이트와 혁신

V2는 최신 결제 기능을 가장 빠르게 제공합니다.
최신 기능을 통해 결제 프로세스를 혁신하고, 고객의 결제 경험을 향상시킬 수 있습니다.

## 사용 가능한 PG사

현재 V2 서비스에서 사용 가능한 PG사는 다음과 같으며, 지속적으로 확장하고 있습니다.

### 결제

- **토스페이먼츠**
- **KSNET**
- **카카오페이**
- **네이버페이**
- **스마트로**
- **나이스정보통신**
- **페이팔**
- **KG이니시스**
- **한국결제네트웍스(KPN)**
- **NHN KCP**
- **토스페이**
- **하이픈 바로계좌결제**

### 본인인증

- **다날 본인인증**

<br />

## 새로워진 V2 시스템과 함께 비즈니스를 한 단계 업그레이드할 준비가 되셨나요?

<br />

<div class="hint" data-style="info">

포트원에서는 결제모듈 V2를 연동하시는 분들께 별도의 기술지원을 추가적으로 지원하고 있습니다.
연동하시면서 기술지원이 필요하시거나 궁금하신 사항이 있으신 경우 아래 이메일로 문의주시기 바랍니다.

- V2 기술지원 이메일: <tech.support@portone.io>

</div>
